type
  TEditControl=class(TCustomEditControl)
  private
   FMousePos           :TPoint;
   FEvBufferChanged    :TEvent;
   FEvCaretLineChange  :TEvent;
   FEvCaretColChange   :TEvent;
   FEvHotlinkClicked   :TEvent;
   FOnAnchorPosChange  :TAnchorPosChangeEvent;
   FOnCaretLineChange  :TNotifyEvent;
   FOnCaretColChange   :TNotifyEvent;
   FOnCodeTemplate     :TNotifyEvent;
   FOnCodeCompletion   :TCodeCompletionEvent;
   FOnClassComplete    :TNotifyEvent;
   FOnClassNavigate    :TClassNavigateEvent;
   FOnChange           :TNotifyEvent;
   FOnUnChanged        :TNotifyEvent;
   FOnClick            :TNotifyEvent;
   FOnHintShow         :THintShowEvent;
   FOnSaveFile         :TNotifyEvent;
   FOnSaveFileAs       :TNotifyEvent;
   FOnReadBlock        :TNotifyEvent;
   FOnRepeatSearch     :TRepeatSearchEvent;
   FOnWriteBlock       :TNotifyEvent;
   FOnHelp             :TNotifyEvent;
   FOnHelpKeyword      :TNotifyEvent;
   FOnNextModification :TNextModificationEvent;
   FHookControls       :THookControlList;
   FLines              :TStrings;
   FUpdating           :Boolean;
   FSmallImages        :TImageList;
   FLargeImages        :TImageList;
   FErrorLine          :Integer;
   FAnchorPos          :TEdPos;
   FLastAnchorPoint    :TPoint;
   FLastMouseClick     :TPoint;
   FCharsDisabled      :Boolean;
   FBorderStyle        :TBorderStyle;
   FOnNavigate         :TNavigateEvent;
   FOnBeginMacroRecord :TNotifyEvent;
   FOnEndMacroRecord   :TNotifyEvent;
   FOnSyncEdit         :TNotifyEvent;
   FLastLeftGutter     :Integer;
   FSearchPanel        :TSearchPanelController;
   FZombieLastHintText :string;
   FCanvas             :TCanvas;
   FAlignControlList   :TList;
   FAlignLevel         :Word;
   FBevelEdges         :TBevelEdges;
   FBevelInner         :TBevelCut;
   FBevelOuter         :TBevelCut;
   FBevelKind          :TBevelKind;
   FBevelWidth         :TBevelWidth;
   FBorderWidth        :TBorderWidth;
   FPadding            :TPadding;
   FBrush              :TBrush;
   FDockClients        :TList;
   FDockManager        :IDockManager;
   FImeMode            :TImeMode;
   FImeName            :TImeName;
   FParentWindow       :HWND;
   FTabList            :TList;
   FControls           :TList;
   FWinControls        :TList;
   FTabOrder           :Integer;
   FTabStop            :Boolean;
   FCtl3D              :Boolean;
   FShowing            :Boolean;
   FUseDockManager     :Boolean;
   FDockSite           :Boolean;
   FParentCtl3D        :Boolean;
   FParentDoubleBuffered:Boolean;
   FPerformingShowingChanged:Boolean;
   FOnDockDrop         :TDockDropEvent;
   FOnDockOver         :TDockOverEvent;
   FOnEnter            :TNotifyEvent;
   FOnExit             :TNotifyEvent;
   FOnGetSiteInfo      :TGetSiteInfoEvent;
   FOnKeyDown          :TKeyEvent;
   FOnKeyPress         :TKeyPressEvent;
   FOnKeyUp            :TKeyEvent;
   FOnUnDock           :TUnDockEvent;
   FOnAlignInsertBefore:TAlignInsertBeforeEvent;
   FOnAlignPosition    :TAlignPositionEvent;
   FMouseInClient      :Boolean;
   FMouseControl       :TControl;
   FTouchControl       :TControl;
   FDefWndProc         :Pointer;
   FHandle             :HWND;
   FObjectInstance     :Pointer;
   FParent             :TWinControl;
   FWindowProc         :TWndMethod;
   FLeft               :Integer;
   FTop                :Integer;
   FWidth              :Integer;
   FHeight             :Integer;
   FControlStyle       :TControlStyle;
   FControlState       :TControlState;
   FDesktopFont        :Boolean;
   FVisible            :Boolean;
   FEnabled            :Boolean;
   FParentFont         :Boolean;
   FParentColor        :Boolean;
   FAlign              :TAlign;
   FAutoSize           :Boolean;
   FDragMode           :TDragMode;
   FIsControl          :Boolean;
   FBiDiMode           :TBiDiMode;
   FParentBiDiMode     :Boolean;
   FAnchors            :TAnchors;
   FFont               :TFont;
   FActionLink         :TControlActionLink;
   FColor              :TColor;
   FConstraints        :TSizeConstraints;
   FMargins            :TMargins;
   FCursor             :TCursor;
   FDragCursor         :TCursor;
   FPopupMenu          :TPopupMenu;
   FHint               :string;
   FFontHeight         :Integer;
   FScalingFlags       :TScalingFlags;
   FShowHint           :Boolean;
   FParentShowHint     :Boolean;
   FDragKind           :TDragKind;
   FDockOrientation    :TDockOrientation;
   FHostDockSite       :TWinControl;
   FWheelAccumulator   :Integer;
   FUndockWidth        :Integer;
   FUndockHeight       :Integer;
   FLRDockWidth        :Integer;
   FTBDockHeight       :Integer;
   FFloatingDockSiteClass:TWinControlClass;
   FTouchManager       :TTouchManager;
   FOnCanResize        :TCanResizeEvent;
   FOnConstrainedResize:TConstrainedResizeEvent;
   FOnMouseDown        :TMouseEvent;
   FOnMouseMove        :TMouseMoveEvent;
   FOnMouseUp          :TMouseEvent;
   FOnDragDrop         :TDragDropEvent;
   FOnDragOver         :TDragOverEvent;
   FOnResize           :TNotifyEvent;
   FOnStartDock        :TStartDockEvent;
   FOnEndDock          :TEndDragEvent;
   FOnStartDrag        :TStartDragEvent;
   FOnEndDrag          :TEndDragEvent;
   FOnClick            :TNotifyEvent;
   FOnDblClick         :TNotifyEvent;
   FOnContextPopup     :TContextPopupEvent;
   FOnMouseActivate    :TMouseActivateEvent;
   FOnMouseLeave       :TNotifyEvent;
   FOnMouseEnter       :TNotifyEvent;
   FOnMouseWheel       :TMouseWheelEvent;
   FOnMouseWheelDown   :TMouseWheelUpDownEvent;
   FOnMouseWheelUp     :TMouseWheelUpDownEvent;
   FOnGesture          :TGestureEvent;
   FHelpType           :THelpType;
   FHelpKeyword        :string;
   FHelpContext        :THelpContext;
   FCustomHint         :TCustomHint;
   FParentCustomHint   :Boolean;
   FText               :PWideChar;
   FOwner              :TComponent;
   FName               :TComponentName;
   FTag                :NativeInt;
   FComponents         :TList;
   FFreeNotifies       :TList;
   FDesignInfo         :Integer;
   FComponentState     :TComponentState;
   FVCLComObject       :Pointer;
   FObservers          :TObservers;
   FSortedComponents   :TList;
   function GetDockClients(Index: Integer): TControl;
   function GetControl(Index: Integer): TControl;
   function GetComponent(AIndex: Integer): TComponent;
  protected
   FStatus             :TCustomStatus;
   FEnableStatusUpdate :Boolean;
   FReadOnly           :Boolean;
   FHideCaret          :Boolean;
   FSyntaxAttributes   :PSyntaxAttributes;
   FFontRecord         :PEdFontRecord;
   FEkView             :PEkView;
   FCurEditView        :TEditView;
   FEditViewIndex      :Integer;
   FWantTabs           :Boolean;
   FWantArrows         :Boolean;
   FWantAllKeys        :Boolean;
   KBD                 :TIDEKBDChildAPI;
   FAnnotationLineProvider:IOTAAnnotationLineProvider;
   FAnnotateGutter     :Integer;
   FMaxAnnotateChar    :Integer;
   FOnlyShowAnnotateHints:Boolean;
   FLeftGutter         :Integer;
   FElisionGutter      :Integer;
   FDisplayLineNumbers :Boolean;
   FLineNumberGutter   :Integer;
   FTextLine           :Integer;
   FShowModifiedLines  :Boolean;
   cxChar              :Integer;
   cyChar              :Integer;
   Caret               :TEdPos;
   SHScrollMax         :SmallInt;
   SVScrollMax         :Integer;
   sHScrollPos         :SmallInt;
   sVScrollPos         :Integer;
   xCursor             :SmallInt;
   yCursor             :Word;
   EVHasFocus          :Boolean;
   CurBkMode           :Integer;
   CurForeColor        :TColor;
   CurBackColor        :TColor;
   CurTextExtra        :Integer;
   DontHideBlock       :Boolean;
   CurStyle            :TFontStyles;
   SyntheticItalic     :Boolean;
   ButtonDown          :Boolean;
   FRightButtonDown    :Boolean;
   MouseMotion         :Boolean;
   MouseDownLine       :Integer;
   MouseDownInBlock    :Boolean;
   MouseDownOnCSIP     :Boolean;
   MouseDownBreakpointIndex:Integer;
   MouseDownBookmarkNumber:Integer;
   DraggingBlock       :Boolean;
   InDragDrop          :Boolean;
   TimerSet            :Boolean;
   GutterBrush         :TBrush;
   FIgnoreKeys         :Boolean;
   HotlinkLine         :Integer;
   HotlinkCol          :SmallInt;
   FLastLineHighlight  :Integer;
   FStartPairPos       :TEdPos;
   FStartPairSize      :Integer;
   FEndPairPos         :TEdPos;
   FEndPairSize        :Integer;
   FLineHint           :THintWindow;
   FDoubleBuffered     :Boolean;
   FInImeComposition   :Boolean;
   FDesignSize         :TPoint;
   FAnchorMove         :Boolean;
   FAnchorRules        :TPoint;
   FAnchorOrigin       :TPoint;
   FOriginalParentSize :TPoint;
   FExplicitLeft       :Integer;
   FExplicitTop        :Integer;
   FExplicitWidth      :Integer;
   FExplicitHeight     :Integer;
   FReserved           :Pointer;
   FComponentStyle     :TComponentStyle;
  public
   constructor Create(AOwner: TComponent);
   class destructor Destroy;
   procedure ClassComplete;
   procedure DefaultHandler(var Message);
   procedure SetEditView(AEditView: TEditView);
   procedure ShowText(TopPos: Integer; Pos: Integer);
   procedure ShowLineCol(Line: Integer; Col: Integer; ShowMode: TShowModes);
   procedure GetAttributeAtPos(const EdPos: TEdPos; var Element: Integer; var LineFlag: Integer; ReportMargin: Boolean; ReturnAllLineFlags: Boolean);
   procedure GetAttributeAtCursor(var Element: Integer; var LineFlag: Integer; CheckEOL: Boolean; ReportMargin: Boolean; ReturnAllLineFlags: Boolean);
   function GetBlockText: string;
   procedure InsertTemplate(Lines: TStrings; const S: string; Line: Integer; Col: Integer; Indent: Boolean; ReplaceToken: Boolean; HighlightToken: Boolean);
   procedure BeginIncrSearch;
   procedure EndIncrSearch;
   procedure BeginMacroRecord;
   procedure EndMacroRecord;
   procedure HandleKeyPress(var Key: Char);
   procedure HandleKeyPress(var Key: AnsiChar);
   procedure CheckError;
   procedure ChangeCharSize;
   procedure ChangeFont;
   procedure CheckHighlighter;
   function DoOneSearch(ReplaceSearch: Boolean; SearchState: PSearchState; var ErrorCode: TSearchResult; var SS: TEdSearchRec): Boolean;
   function DoReplace(var ErrorCode: TSearchResult; var SS: TEdSearchRec): Boolean;
   function DoReplace(var ErrorCode: TSearchResult): Boolean;
   function DoSearch(var ErrorCode: TSearchResult; var SS: TEdSearchRec): Boolean;
   function DoSearch(var ErrorCode: TSearchResult): Boolean;
   procedure EdRefresh(ForceTailErase: Boolean);
   procedure EndSearch(SearchState: PSearchState);
   procedure HideBlock;
   function RealToFrozen(ActualLine: Integer): Integer;
   procedure SetErrorLine(LineNum: Integer);
   procedure UpdateStatus;
   procedure InsertTextAtCursor(const Text: string);
   function PointFromEdPos(EdPos: TEdPos; CalcLine: Boolean; CalcCol: Boolean): TPoint;
   procedure CancelMouseActions;
   function IndexPosToCurPos(xIndex: SmallInt; LineNum: Integer): SmallInt;
   function CurPosToIndexPos(Col: SmallInt; LineNum: Integer): SmallInt;
   procedure StartPlayback;
   procedure StopPlayback;
   procedure SetBookmark(MarkerNum: Integer);
   procedure GotoBookmark(MarkerNum: Integer);
   procedure SetLeftGutter;
   procedure DoCommandExecute(Cmd: PAnsiChar);
   procedure AddElisionBlock(const X: TCharPos; const Y: TCharPos; const Description: TElisionDescription);
   procedure RemoveElisionBlock(const X: TCharPos);
   procedure RemoveElisionBlock(const X: TCharPos; const Y: TCharPos);
   procedure ImplicitUnElide(const X: TCharPos);
   procedure ImplicitUnElide(const X: TCharPos; const Y: TCharPos);
   procedure EndImplicitUnElide(const X: TCharPos);
   procedure EndImplicitUnElide(const X: TCharPos; const Y: TCharPos);
   function IsStartOfElisionBlock(LineNum: Integer): Boolean;
   function PointIsElided(LineNum: Integer; Column: Integer): Boolean;
   function BlockIsElided(LineNum: Integer): Boolean;
   function IsEndOfElisionBlock(LineNum: Integer): Boolean;
   function IsStartOrEndOfElisionBlock(LineNum: Integer): Boolean;
   function IsInElisionBlock(LineNum: Integer): Boolean;
   procedure Elide(const X: TCharPos; Children: Boolean);
   procedure Elide(const X: TCharPos; const Y: TCharPos; Children: Boolean);
   procedure Elide(X: Integer);
   procedure UnElide(const X: TCharPos; Parents: Boolean);
   procedure UnElide(const X: TCharPos; const Y: TCharPos; Parents: Boolean);
   procedure unElide(X: Integer);
   procedure ClearAllElisions;
   procedure Append;
   procedure DoAbstractElide;
   procedure Clear;
   procedure CloseView;
   procedure Copy;
   procedure Cut;
   procedure DoRedo;
   procedure DoUndo;
   procedure GotoLine;
   procedure IncrementalSearch;
   procedure InsertNewGUID;
   procedure MenuIncrementalSearch;
   procedure MenuSearch;
   procedure MenuReplace;
   procedure MenuRepeatSearch;
   procedure MenuGotoLine;
   procedure Paste;
   procedure RepeatSearch;
   function Replace: Integer;
   function Replace(var SS: TEdSearchRec): Integer;
   function Search: Boolean;
   function Search(var SS: TEdSearchRec): Boolean;
   procedure SelectAll;
   procedure Print;
   procedure ToggleBreakpoint(ToggleDisable: Boolean);
   procedure NextModification(Direction: TSearchDirection; ModificationType: TOTAModificationType);
   procedure HelpKeyword;
   procedure InsertOptions;
   procedure LocalMenu;
   procedure ReadBlock;
   procedure SaveFile;
   procedure SaveFileAs;
   procedure WriteBlock;
   procedure ToggleComment(MoveCursor: Boolean);
   procedure EnableBreakpoint;
   function GetTextAtLine(LineNum: Integer): string;
   constructor Create(AOwner: TComponent);
   class destructor Destroy;
   constructor Create(AOwner: TComponent);
   constructor CreateParented(ParentWindow: HWND);
   class function CreateParentedControl(ParentWindow: HWND): TWinControl;
   class destructor Destroy;
   procedure Broadcast(var Message);
   function CanFocus: Boolean;
   function ContainsControl(Control: TControl): Boolean;
   function ControlAtPos(const Pos: TPoint; AllowDisabled: Boolean; AllowWinControls: Boolean; AllLevels: Boolean): TControl;
   procedure DefaultHandler(var Message);
   procedure DisableAlign;
   procedure DockDrop(Source: TDragDockObject; X: Integer; Y: Integer);
   procedure EnableAlign;
   function FindChildControl(const ControlName: string): TControl;
   procedure FlipChildren(AllLevels: Boolean);
   function Focused: Boolean;
   procedure GetChildren(Proc: TGetChildProc = procedure(Child: TComponent) of object; Root: TComponent);
   procedure GetTabControlList(List: TList);
   procedure GetTabOrderList(List: TList);
   function HandleAllocated: Boolean;
   procedure HandleNeeded;
   procedure InsertControl(AControl: TControl);
   procedure Invalidate;
   procedure PaintTo(DC: HDC; X: Integer; Y: Integer);
   procedure PaintTo(Canvas: TCanvas; X: Integer; Y: Integer);
   function PreProcessMessage(var Msg: tagMSG): Boolean;
   procedure RemoveControl(AControl: TControl);
   procedure Realign;
   procedure Repaint;
   procedure ScaleBy(M: Integer; D: Integer);
   procedure ScrollBy(DeltaX: Integer; DeltaY: Integer);
   procedure SetBounds(ALeft: Integer; ATop: Integer; AWidth: Integer; AHeight: Integer);
   procedure SetDesignVisible(Value: Boolean);
   procedure SetFocus;
   procedure Update;
   procedure UpdateControlState;
   constructor Create(AOwner: TComponent);
   class destructor Destroy;
   procedure BeginDrag(Immediate: Boolean; Threshold: Integer);
   procedure BringToFront;
   function ClientToScreen(const Point: TPoint): TPoint;
   function ClientToParent(const Point: TPoint; AParent: TWinControl): TPoint;
   procedure Dock(NewDockSite: TWinControl; ARect: TRect);
   function Dragging: Boolean;
   procedure DragDrop(Source: TObject; X: Integer; Y: Integer);
   function DrawTextBiDiModeFlags(Flags: Integer): Integer;
   function DrawTextBiDiModeFlagsReadingOnly: Integer;
   procedure EndDrag(Drop: Boolean);
   function GetControlsAlignment: TAlignment;
   function GetParentComponent: TComponent;
   function HasParent: Boolean;
   procedure Hide;
   procedure InitiateAction;
   procedure Invalidate;
   procedure MouseWheelHandler(var Message: TMessage);
   function IsRightToLeft: Boolean;
   function ManualDock(NewDockSite: TWinControl; DropControl: TControl; ControlSide: TAlign): Boolean;
   function ManualFloat(ScreenPos: TRect): Boolean;
   function Perform(Msg: Cardinal; WParam: NativeUInt; LParam: NativeInt): NativeInt;
   procedure Refresh;
   procedure Repaint;
   function ReplaceDockedControl(Control: TControl; NewDockSite: TWinControl; DropControl: TControl; ControlSide: TAlign): Boolean;
   function ScreenToClient(const Point: TPoint): TPoint;
   function ParentToClient(const Point: TPoint; AParent: TWinControl): TPoint;
   procedure SendToBack;
   procedure SetBounds(ALeft: Integer; ATop: Integer; AWidth: Integer; AHeight: Integer);
   procedure SetDesignVisible(Value: Boolean);
   procedure SetParentComponent(Value: TComponent);
   procedure Show;
   procedure Update;
   function UseRightToLeftAlignment: Boolean;
   function UseRightToLeftReading: Boolean;
   function UseRightToLeftScrollBar: Boolean;
   procedure DefaultHandler(var Message);
   function GetTextBuf(Buffer: PWideChar; BufSize: Integer): Integer;
   function GetTextLen: Integer;
   function Perform(Msg: Cardinal; WParam: NativeUInt; LParam: PWideChar): NativeInt;
   function Perform(Msg: Cardinal; WParam: NativeUInt; var LParam: TRect): NativeInt;
   procedure SetTextBuf(Buffer: PWideChar);
   constructor Create(AOwner: TComponent);
   class destructor Destroy;
   procedure BeforeDestruction;
   procedure DestroyComponents;
   procedure Destroying;
   function ExecuteAction(Action: TBasicAction): Boolean;
   function FindComponent(const AName: string): TComponent;
   procedure FreeNotification(AComponent: TComponent);
   procedure RemoveFreeNotification(AComponent: TComponent);
   procedure FreeOnRelease;
   function GetEnumerator: TComponentEnumerator;
   function GetParentComponent: TComponent;
   function GetNamePath: string;
   function HasParent: Boolean;
   procedure InsertComponent(AComponent: TComponent);
   procedure RemoveComponent(AComponent: TComponent);
   procedure SetSubComponent(IsSubComponent: Boolean);
   function SafeCallException(ExceptObject: TObject; ExceptAddr: Pointer): HRESULT;
   function UpdateAction(Action: TBasicAction): Boolean;
   function IsImplementorOf(const I: IInterface): Boolean;
   function ReferenceInterface(const I: IInterface; Operation: TOperation): Boolean;
   class destructor Destroy;
   procedure Assign(Source: TPersistent);
   function GetNamePath: string;
   constructor Create;
   procedure Free;
   class function InitInstance(Instance: Pointer): TObject;
   procedure CleanupInstance;
   function ClassType: TClass;
   class function ClassName: string;
   class function ClassNameIs(const Name: string): Boolean;
   class function ClassParent: TClass;
   class function ClassInfo: Pointer;
   class function InstanceSize: Integer;
   class function InheritsFrom(AClass: TClass): Boolean;
   class function MethodAddress(const Name: ShortString): Pointer;
   class function MethodAddress(const Name: string): Pointer;
   class function MethodName(Address: Pointer): string;
   class function QualifiedClassName: string;
   function FieldAddress(const Name: ShortString): Pointer;
   function FieldAddress(const Name: string): Pointer;
   function GetInterface(const IID: TGUID; out Obj): Boolean;
   class function GetInterfaceEntry(const IID: TGUID): PInterfaceEntry;
   class function GetInterfaceTable: PInterfaceTable;
   class function UnitName: string;
   class function UnitScope: string;
   function Equals(Obj: TObject): Boolean;
   function GetHashCode: Integer;
   function ToString: string;
   function SafeCallException(ExceptObject: TObject; ExceptAddr: Pointer): HRESULT;
   procedure AfterConstruction;
   procedure BeforeDestruction;
   procedure Dispatch(var Message);
   procedure DefaultHandler(var Message);
   class function NewInstance: TObject;
   procedure FreeInstance;
   class destructor Destroy;
   property AnchorPoint: TPoint;
   property AnchorPos: TEdPos;
   property BorderStyle: TBorderStyle;
   property EnableStatusUpdate: Boolean;
   property EkView: PEkView;
   property CharsDisabled: Boolean;
   property CharWidth: Integer;
   property CharHeight: Integer;
   property CurEditView: TEditView;
   property DisplayLineNumbers: Boolean;
   property FontRecord: PEdFontRecord;
   property HookControls: THookControlList;
   property LargeImages: TImageList;
   property LastMouseClick: TPoint;
   property LeftGutter: Integer;
   property Lines: TStrings;
   property RightButtonDown: Boolean;
   property SmallImages: TImageList;
   property Updating: Boolean;
   property WantArrows: Boolean;
   property WantAllKeys: Boolean;
   property WantTabs: Boolean;
   property ShowModifiedLines: Boolean;
   property ParentShowHint: Boolean;
   property EvBufferChanged: TEvent;
   property EvHotlinkClicked: TEvent;
   property OnAnchorPosChange: TAnchorPosChangeEvent;
   property OnChange: TNotifyEvent;
   property OnDragOver: TDragOverEvent;
   property OnEnter: TNotifyEvent;
   property OnExit: TNotifyEvent;
   property OnUnChange: TNotifyEvent;
   property OnCaretColChange: TNotifyEvent;
   property OnCaretLineChange: TNotifyEvent;
   property EvCaretLineChange: TEvent;
   property EvCaretColChange: TEvent;
   property OnClick: TNotifyEvent;
   property OnCodeCompletion: TCodeCompletionEvent;
   property OnCodeTemplate: TNotifyEvent;
   property OnClassComplete: TNotifyEvent;
   property OnClassNavigate: TClassNavigateEvent;
   property OnNavigate: TNavigateEvent;
   property OnHintShow: THintShowEvent;
   property OnKeyPress: TKeyPressEvent;
   property OnReadBlock: TNotifyEvent;
   property OnRepeatSearch: TRepeatSearchEvent;
   property OnSaveFile: TNotifyEvent;
   property OnSaveFileAs: TNotifyEvent;
   property OnWriteBlock: TNotifyEvent;
   property OnHelp: TNotifyEvent;
   property OnHelpKeyword: TNotifyEvent;
   property OnBeginMacroRecord: TNotifyEvent;
   property OnEndMacroRecord: TNotifyEvent;
   property OnSyncEdit: TNotifyEvent;
   property OnNextModification: TNextModificationEvent;
   property ReadOnly: Boolean;
   property HideCaret: Boolean;
   property Status: TCustomStatus;
   property SyntaxAttributes: PSyntaxAttributes;
   property PopupMenu: TPopupMenu;
   property SearchPanel: TSearchPanelController;
   property AnnotationLineProvider: IOTAAnnotationLineProvider;
   property OnlyShowAnnotateHints: Boolean;
   property DockClientCount: Integer;
   property DockSite: Boolean;
   property DockManager: IDockManager;
   property DoubleBuffered: Boolean;
   property AlignDisabled: Boolean;
   property MouseInClient: Boolean;
   property VisibleDockClientCount: Integer;
   property Brush: TBrush;
   property ControlCount: Integer;
   property Handle: HWND;
   property Padding: TPadding;
   property ParentDoubleBuffered: Boolean;
   property ParentWindow: HWND;
   property Showing: Boolean;
   property TabOrder: TTabOrder;
   property TabStop: Boolean;
   property UseDockManager: Boolean;
   property Enabled: Boolean;
   property Action: TBasicAction;
   property Align: TAlign;
   property Anchors: TAnchors;
   property BiDiMode: TBiDiMode;
   property BoundsRect: TRect;
   property ClientHeight: Integer;
   property ClientOrigin: TPoint;
   property ClientRect: TRect;
   property ClientWidth: Integer;
   property Constraints: TSizeConstraints;
   property ControlState: TControlState;
   property ControlStyle: TControlStyle;
   property DockOrientation: TDockOrientation;
   property ExplicitLeft: Integer;
   property ExplicitTop: Integer;
   property ExplicitWidth: Integer;
   property ExplicitHeight: Integer;
   property Floating: Boolean;
   property FloatingDockSiteClass: TWinControlClass;
   property HostDockSite: TWinControl;
   property LRDockWidth: Integer;
   property ShowHint: Boolean;
   property TBDockHeight: Integer;
   property Touch: TTouchManager;
   property UndockHeight: Integer;
   property UndockWidth: Integer;
   property Visible: Boolean;
   property WindowProc: TWndMethod;
   property Parent: TWinControl;
   property OnGesture: TGestureEvent;
   property ComObject: IInterface;
   property ComponentCount: Integer;
   property ComponentIndex: Integer;
   property ComponentState: TComponentState;
   property ComponentStyle: TComponentStyle;
   property DesignInfo: Integer;
   property Owner: TComponent;
   property VCLComObject: Pointer;
   property Observers: TObservers;
  published
   property BorderStyle: TBorderStyle;
   property BlockBegin: Integer;
   property BlockAfter: Integer;
   property CaretX: SmallInt;
   property CharXIndex: SmallInt;
   property CaretY: Integer;
   property CursorAttribute: Integer;
   property LineCount: Integer;
   property LinesInWindow: Integer;
   property LineText: string;
   property SearchBegin: Integer;
   property SearchAfter: Integer;
   property TopLine: Integer;
   property HotlinkText: string;
   property CaretPixelX: Integer;
   property CaretPixelY: Integer;
   property ZombieLastHintText: string;
   property ZombieAnnotationIntensity: Integer;
   property ZombieAnnotationGutterText: string;
   property ZombieHistoryDiffState: Integer;
   property AlignWithMargins: Boolean;
   property Left: Integer;
   property Top: Integer;
   property Width: Integer;
   property Height: Integer;
   property Cursor: TCursor;
   property Hint: string;
   property HelpType: THelpType;
   property HelpKeyword: string;
   property HelpContext: THelpContext;
   property Margins: TMargins;
   property CustomHint: TCustomHint;
   property ParentCustomHint: Boolean;
   property Name: TComponentName;
   property Tag: NativeInt;
  end;
